// Autor: Ivan Katanic

#include <algorithm>
#include <cstring>
#include <iostream>

using namespace std;

const int MAX = 1010;

struct BoundingBox {
  int x1, y1, x2, y2;
  
  void clear() {
    x1 = y1 = MAX;
    x2 = y2 = 0;
  }
  
  void add(int x, int y) {
    x1 = min(x1, x);
    x2 = max(x2, x);
    y1 = min(y1, y);
    y2 = max(y2, y);
  }

  int perimeter() {
    if (x1 > x2) return 0;
    return 2*(x2-x1+1 + y2-y1+1);
  }
};

char a[MAX][MAX];
int L[MAX], R[MAX], U[MAX], D[MAX];

int main(void) {
  int n, m;
  scanf("%d %d", &n, &m);
  for (int i = 0; i < n; ++i)
    scanf("%s", a[i]);

  BoundingBox b;

  b.clear();
  for (int i = 0; i < n; ++i) {
    for (int j = 0; j < m; ++j)
      if (a[i][j] == 'O') b.add(i, j);
    U[i] = b.perimeter();
  }

  b.clear();
  for (int i = n-1; i >= 0; --i) {
    for (int j = 0; j < m; ++j)
      if (a[i][j] == 'O') b.add(i, j);
    D[i] = b.perimeter();;
  }

  b.clear();
  for (int j = 0; j < m; ++j) {
    for (int i = 0; i < n; ++i)
      if (a[i][j] == 'O') b.add(i, j);
    L[j] = b.perimeter();
  }

  b.clear();
  for (int j = m-1; j >= 0; --j) {
    for (int i = 0; i < n; ++i)
      if (a[i][j] == 'O') b.add(i, j);
    R[j] = b.perimeter();
  }

  int ans = b.perimeter(); // jedna ograda
  // horizontalni rez
  for (int i = 0; i < n-1; ++i)
    ans = min(ans, U[i] + D[i+1]);
  // vertikalni rez
  for (int j = 0; j < m-1; ++j)
    ans = min(ans, L[j] + R[j+1]);
  
  printf("%d\n", ans);
  return 0;
}
